@REM @file
@REM
@REM @copyright
@REM  INTEL CONFIDENTIAL
@REM  Copyright 2014 - 2017 Intel Corporation.
@REM
@REM  The source code contained or described herein and all documents related to the
@REM  source code ("Material") are owned by Intel Corporation or its suppliers or
@REM  licensors. Title to the Material remains with Intel Corporation or its suppliers
@REM  and licensors. The Material may contain trade secrets and proprietary and
@REM  confidential information of Intel Corporation and its suppliers and licensors,
@REM  and is protected by worldwide copyright and trade secret laws and treaty
@REM  provisions. No part of the Material may be used, copied, reproduced, modified,
@REM  published, uploaded, posted, transmitted, distributed, or disclosed in any way
@REM  without Intel's prior express written permission.
@REM
@REM  No license under any patent, copyright, trade secret or other intellectual
@REM  property right is granted to or conferred upon you by disclosure or delivery
@REM  of the Materials, either expressly, by implication, inducement, estoppel or
@REM  otherwise. Any license under such intellectual property rights must be
@REM  express and approved by Intel in writing.
@REM
@REM  Unless otherwise agreed by Intel in writing, you may not remove or alter
@REM  this notice or any other notice embedded in Materials by Intel or
@REM  Intel's suppliers or licensors in any way.
@REM
@REM  This file contains a 'Sample Driver' and is licensed as such under the terms
@REM  of your license agreement with Intel or your vendor. This file may be modified
@REM  by the user, subject to the additional terms of the license agreement.
@REM
@REM @par Specification Reference:
@REM

:: Useage: bld [/s] [/f <FEATURE_PCD_NAME> <FALSE or TRUE>] [/r]
::
:: For a given build command, 3 options may be passed into this batch file via command prompt:
:: 1) /s = Redirects all output to a file called EDK2.log(Prep.log must be existed), which will be located at the root.
:: 2) /f = Defines the passing in of a single override to a feature PCD that is used in the platform
::    DSC file.  If this parameter is used, it is to be followed immediately after by both the feature
::    pcd name and value. FeaturePcd is the full PCD name, like gPlatformModuleTokenSpaceGuid.PcdOptimizeCompilerEnable
:: 3) /r = Useful for faster rebuilds when no changes have been made to .inf files. Passes -u to
::    build.exe to skip the generation of makefiles.
:: 4) rom = Build Bios.rom only and building SPIs will be skipped.
::
:: For multiple feature PCD override support, please configure them together in PlatformPkgExtConfig.dsc file.
:: Simply set it prior to running prep.bat file with the desired FeaturePcd that are to be overriden.
:: The latter one will override the previous one in PlatformPkgExtConfig.dsc.
:: The example is as follows:
::   gPlatformModuleTokenSpaceGuid.PcdOptimizeCompilerEnable|TRUE

@echo on

cd %WORKSPACE%

@REM
@REM Build FSP Binary
@REM
@if not defined FSP_BINARY_BUILD goto :SkipFspBinaryBuild
@if %FSP_BINARY_BUILD% EQU FALSE goto :SkipFspBinaryBuild
@set FSP_BUILD_PARAMETER=/d
@set FSP_PKG_NAME=KabylakeFspPkg
@if /I "%TARGET%" == "RELEASE" (
  @if "%FSP_TEST_RELEASE%"=="TRUE" (
    set FSP_BUILD_PARAMETER=/tr
  ) else (
    set FSP_BUILD_PARAMETER=/r
  )
)


@rem
@rem TODO: Waiting FSP support catalog
@rem
@type %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\PlatformPkgExtConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gClientCommonModuleTokenSpaceGuid.PcdCatalogDebugEnable|TRUE" > NUL
  @if not errorlevel 1 (
    echo gSiPkgTokenSpaceGuid.PcdSiCatalogDebugEnable^|FALSE >> %WORKSPACE_SILICON%\%FSP_PKG_NAME%\%FSP_PKG_NAME%ExtConfig.dsc
  )
)

call BuildFsp.cmd KBL %FSP_BUILD_PARAMETER%
@if %ERRORLEVEL% NEQ 0 (
  @echo !!! ERROR:Build Fail !!!
  @echo BuildFsp.cmd KBL %FSP_BUILD_PARAMETER%
  set SCRIPT_ERROR=1
  goto :BldFail
)
@if %FSP_WRAPPER_BUILD% EQU FALSE goto :BldEnd
:SkipFspBinaryBuild

@if %FSP_WRAPPER_BUILD% EQU FALSE goto :SkipPatchFspBinFvsBaseAddress
@if exist %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\PlatformPkg.dsc attrib -r %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\PlatformPkg.dsc
del /f %WORKSPACE_SILICON%\KabylakeFspBinPkg\Fsp_Rebased*.fd

@if %SECURE_BOOT_ENABLE% EQU TRUE (
  @call python %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\Fsp\RebaseAndPatchFspBinBaseAddress.py %TARGET% %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\FlashMap\SIZE_80_FSP_WRAPPER.fdf %WORKSPACE_SILICON%\KabylakeFspBinPkg Fsp.fd %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\PlatformPkg.dsc 0x2B0
) else (
  @call python %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\Fsp\RebaseAndPatchFspBinBaseAddress.py %TARGET% %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\FlashMap\SIZE_80_FSP_WRAPPER.fdf %WORKSPACE_SILICON%\KabylakeFspBinPkg Fsp.fd %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\PlatformPkg.dsc 0x70
)
@if %ERRORLEVEL% NEQ 0 (
  @echo !!! ERROR:RebaseAndPatchFspBinBaseAddress failed!!!
  set SCRIPT_ERROR=1
  goto :BldFail
)
copy /y /b %WORKSPACE_SILICON%\KabylakeFspBinPkg\Fsp_Rebased_M.fd+%WORKSPACE_SILICON%\KabylakeFspBinPkg\Fsp_Rebased_T.fd %WORKSPACE_SILICON%\KabylakeFspBinPkg\Fsp_Rebased_M_T.fd
@REM prefix pad.bin file which adds 0xC bytes of data (Note: Section will add 4 bytes of SECTION Header). This is done to align the FSP Header to 16 bytes
copy /y /b %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\Fsp\pad.bin+%WORKSPACE_SILICON%\KabylakeFspBinPkg\Fsp_Rebased_S.fd %WORKSPACE_SILICON%\KabylakeFspBinPkg\Fsp_Rebased_S_padded.fd
:SkipPatchFspBinFvsBaseAddress

@REM
@REM AdvancedFeaturesBegin
@REM
@type %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\PlatformPkgExtConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdUnitoolEnable" > NUL
@if not errorlevel 1 (
  @type %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\PlatformPkgExtConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdUnitoolEnable|TRUE" > NUL
  @if errorlevel 1 (
    goto SkipUniTool
  )
) else (
  @type %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\PlatformPkgConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdUnitoolEnable|TRUE" > NUL
  @if errorlevel 1 (
    goto SkipUniTool
  )
)
call %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\UniTool\UniTool.bat
@if %ERRORLEVEL% NEQ 0 goto BldFail

:SkipUniTool
@REM
@REM AdvancedFeaturesEnd
@REM

@SET SILENT_MODE=FALSE
@SET REBUILD_MODE=
@SET BUILD_ROM_ONLY=

:: Loop through arguements until all are processed

:BUILD_FLAGS_LOOP

@if "%~1" == "" goto BUILD_FLAGS_LOOP_DONE

@if "%~1" == "/f" (
  echo %2^|%3 >> %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\PlatformPkgExtConfig.dsc
  shift
  shift
  shift
  goto BUILD_FLAGS_LOOP
)
@if "%~1" == "/s" (
  SET SILENT_MODE=TRUE
  shift
  goto BUILD_FLAGS_LOOP
)
@if "%~1" == "/r" (
  SET REBUILD_MODE=-u
  shift
  goto BUILD_FLAGS_LOOP
)
@if "%~1" == "rom" (
  SET BUILD_ROM_ONLY=rom
  shift
  goto BUILD_FLAGS_LOOP
)
:: Unknown build flag.
shift
goto BUILD_FLAGS_LOOP
:BUILD_FLAGS_LOOP_DONE

:: Output the build variables the user has selected.

@echo.
@echo  User Selected build options:
@echo    SILENT_MODE = %SILENT_MODE%
@echo    REBUILD_MODE = %REBUILD_MODE%
@echo    BUILD_ROM_ONLY = %BUILD_ROM_ONLY%
@echo.

@if %SILENT_MODE% EQU TRUE goto BldSilent

build -n %NUMBER_OF_PROCESSORS% %REBUILD_MODE% %EXT_BUILD_FLAGS%

@if %ERRORLEVEL% NEQ 0 goto BldFail
@echo.
@echo Running postbuild.bat to complete the build process.
@echo.
call %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\postbuild.bat %BUILD_ROM_ONLY%
@If %SCRIPT_ERROR% EQU 1 goto BldFail
@goto BldSuccess

:BldSilent
@if exist Build.log del Build.log

@echo. > Build.log
@echo ************************************************************************ >> Build.log
@echo ***********             Build.bat is launched here           *********** >> Build.log
@echo ************************************************************************ >> Build.log
@echo. >> Build.log

build -n %NUMBER_OF_PROCESSORS% %REBUILD_MODE% %EXT_BUILD_FLAGS% 1>>Build.log 2>&1

@if %ERRORLEVEL% NEQ 0 goto BldFail
@echo. >> Build.log
@echo Running postbuild.bat to complete the build process. >> Build.log
@echo. >> Build.log
@call %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\postbuild.bat %BUILD_ROM_ONLY% 1>>Build.log 2>&1
@If %SCRIPT_ERROR% EQU 1 goto BldFail

:BldSuccess
@echo.
@echo TARGET:               %TARGET%
@echo TOOL_CHAIN_TAG:       %TOOL_CHAIN_TAG%
@echo BIOS location:        %BUILD_DIR%\FV
@echo SPI Images location:  %WORKSPACE%\RomImages
@echo.
@echo The EDKII BIOS build has successfully completed!
@echo.
@REM
@REM Save the build context for use by the optional post build script for Secure Boot Image creation
@REM
@echo @REM Save the build context for use by the post build Secure Boot Image creation. > %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\SecureBootPreBuild.bat
@echo @REM>>%WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\SecureBootPreBuild.bat
@echo set TOOL_CHAIN_TAG=%TOOL_CHAIN_TAG%>> %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\SecureBootPreBuild.bat
@echo set WORKSPACE=%WORKSPACE%>> %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\SecureBootPreBuild.bat
@echo set TARGET=%TARGET%>> %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\SecureBootPreBuild.bat
@echo set PLATFORM_PACKAGE=%PLATFORM_PACKAGE%>> %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\SecureBootPreBuild.bat
@echo set CLIENT_COMMON_PACKAGE=ClientCommonPkg>> %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\SecureBootPreBuild.bat
@echo set BUILD_DIR=Build\%PLATFORM_PACKAGE%\%TARGET%_%TOOL_CHAIN_TAG%>> %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\SecureBootPreBuild.bat
@echo set BIOS_ID_FILE=%BUILD_DIR%\BiosId.env>> %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\SecureBootPreBuild.bat
@echo set BIOS_MAJOR_VERSION=%BIOS_MAJOR_VERSION%>> %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\SecureBootPreBuild.bat
@echo set BIOS_MIN_VERSION=%BIOS_MIN_VERSION%>> %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\SecureBootPreBuild.bat

@goto BldEnd

:BldFail
cd %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%
@echo.
@echo The EDKII BIOS Build has failed!
@echo.
@exit /b 1

:BldEnd
@if %SILENT_MODE% EQU TRUE (
  @if exist EDK2.log del EDK2.log
  @if exist Prep.log if exist Build.log copy Prep.log+Build.log EDK2.log
)

cd %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%